global function initFrontierDefenseData
void function initFrontierDefenseData()
{
	useCustomFDLoad = true
	AddCallback_RegisterCustomFDContent( RegisterCustomFDContent )
		
    PlaceFDShop( < -2503, -2287, 80 >, < 0, 90, 0 > )
	SetFDDropshipSpawn( < -613, -920, 208 >, < 0, 90, 0 > )
	SetFDGroundSpawn( < -923, -563, 208 >, < 0, -90, 0 > )
	
	AddFDDropPodSpawn( < -2372, -1430, 72 > )
	AddFDDropPodSpawn( < -682, -1113, 208 > )
	AddFDDropPodSpawn( < -264, -2126, 260 > )
	
	AddWaveAnnouncement( "fd_introEasy" )
	AddWaveAnnouncement( "fd_waveTypeReapers" )
	AddWaveAnnouncement( "fd_waveTypeTitanMortar" )
	AddWaveAnnouncement( "fd_waveComboArcNuke" )
	AddWaveAnnouncement( "fd_finalWaveStartGeneric" )

	/*
	 __      __                 _ 
	 \ \    / /__ _ __ __ ___  / |
	  \ \/\/ // _` |\ V // -_) | |
	   \_/\_/ \__,_| \_/ \___| |_|
	
	*/
    array<WaveSpawnEvent> wave1
	WaveSpawn_InfantrySpawn( wave1, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 1.0, "fd_waveTypeInfantry", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave1, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 1.0, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 4763, -841, 64 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 2 )
	
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 3894, 10, 72 >, 0.0, "desertBuildingsInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 3488, -9, 72 >, 0.0, "desertBuildingsInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 1259, 2233, 64 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 4 )
	
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < -138, 2326, 75 >, 0.0, "", 0.2 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < -956, 2570, 144 >, 0.0, "", 0.3 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < -3305, 217, 96 >, 0.0, "", 0.4 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < -3682, 366, 28 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 4 )
	
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < -1655, 2141, 128 >, 0.0, "", 1.8 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 1781, -2171, 72 >, 0.0, "", 2.0 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < 3701, -77, 72 >, 0.0, "", 4.0, "fd_waveTypeMortarSpectre" )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < -3849, 143, 22 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 4 )
	
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < 1559, 2165, 67 >, 0.0, "", 0.6 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < 2211, -3009, 56 >, 0.0, "", 0.8 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < 996, 316, 67 >, 0.0, "", 2.0 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 1037, 713, 67 >, 0.0, "acrossAvenueInfantry", 1.2 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 1442, 411, 67 >, 0.0, "acrossAvenueInfantry", 0.8 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 1018, 251, 67 >, 0.0, "acrossAvenueInfantry" )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 4 )
	
	WaveSpawn_InfantrySpawn( wave1, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 1.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < -1924, 2952, 140 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < -1056, 2152, 138 >, 0.0, "", 2.0 )
	WaveSpawn_InfantrySpawn( wave1, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 4 )
	
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < -3860, 225, 17 >, 0.0, "", 0.1 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < -3465, 347, 69 >, 0.0, "", 0.2 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < -3864, -395, -14 >, 0.0, "", 0.3 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 2713, -2322, 63 >, 0.0, "", 0.4 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 3218, -1852, 65 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", < 1722, -953, 68 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 4 )
	
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < 3337, 2823, 64 >, 0.0, "", 1.5 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < 3147, -1550, 66 >, 0.0, "", 1.6 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < 3948, -804, 72 >, 0.0, "", 2.7 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < 2437, -848, 65 >, 0.0, "", 1.8 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < -3528, 534, 54 >, 0.0, "", 1.9 )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", < -1922, 1525, 136 >, 0.0, "" )
	
    WaveSpawnEvents.append( wave1 )
	
	/*
	 __      __                 ___ 
	 \ \    / /__ _ __ __ ___  |_  )
	  \ \/\/ // _` |\ V // -_)  / / 
	   \_/\_/ \__,_| \_/ \___| /___|
	
	*/
	array<WaveSpawnEvent> wave2
	WaveSpawn_InfantrySpawn( wave2, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5, "fd_waveTypeFlyers" )
	WaveSpawn_InfantrySpawn( wave2, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave2, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 2 )
	
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < -2243, 2107, 170 >, -105, "", 0.6, "fd_incReaperClump" )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < -3207, 1641, 165 >, -50, "", 0.7 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < -3012, 3221, 196 >, -50, "", 0.4 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < -334, 3300, 90 >, -120, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < -329, 2625, 139 >, -90, "", 0.8 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < -592, 2003, 106 >, -33, "", 2.5 )
	WaveSpawn_InfantrySpawn( wave2, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 0.5 )
	WaveSpawn_InfantrySpawn( wave2, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 1.5 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < 2240, -2888, 57 >, 0.0, "eastBuildingsInfantry", 0.3 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < 2250, -3230, 63 >, 0.0, "eastBuildingsInfantry", 0.2 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < 1371, -2711, 72 >, 0.0, "eastBuildingsInfantry", 0.3 )
	WaveSpawn_InfantrySpawn( wave2, "DropshipGrunt", < 2294, -3422, 60 >, 128, "eastBuildingsInfantry", 0.4, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", < 1496, 1292, 72 >, 0.0, "", 0.6 )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", < 2881, 709, 72 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 6 )
	
	WaveSpawn_TitanSpawn( wave2, "Monarch", < 1676, 2623, 67 >, -120, "", 0.8, "fd_waveTypeTitanReg" )
	WaveSpawn_TitanSpawn( wave2, "Tone", < -2770, 3354, 177 >, -90, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 0 )
	
	WaveSpawn_InfantrySpawn( wave2, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < 1037, 713, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < 1442, 411, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < 1018, 251, 67 >, 0.0, "acrossAvenueInfantry" )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 6 )
	
	WaveSpawn_InfantrySpawn( wave2, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave2, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 0.6 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < -3860, 225, 17 >, 0.0, "", 0.4 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < -3465, 347, 69 >, 0.0, "", 0.8 )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", < -3864, -395, -14 >, 0.0, "", 0.2 )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", < -1007, 2140, 125 >, 0.0, "", 0.3 )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", < 2279, 2953, 120 >, 0.0, "", 0.4 )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", < 3952, -822, 72 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 8 )
	
	WaveSpawn_TitanSpawn( wave2, "Tone", < 5691, -908, 73 >, 150, "", 0.5 )
	WaveSpawn_TitanSpawn( wave2, "Tone", < 5308, -1382, 76 >, 150, "", 0.5 )
	WaveSpawn_TitanSpawn( wave2, "Tone", < -56, 3040, 71 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave2, "Tone", < -3020, 3082, 196 >, -90, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 4 )
	
	WaveSpawn_InfantrySpawn( wave2, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 1.0, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave2, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 2.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5398, 602, 67 >, -175, "", 0.8, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5398, 602, 67 >, -175, "", 0.2, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5094, 2244, 63 >, -120, "", 0.4, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 3696, 2690, 63 >, -130, "", 0.6, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5094, 2244, 63 >, -120, "", 0.5, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5398, 602, 67 >, -175, "", 0.4, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5282, -1081, 75 >, 180, "", 0.7, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 3696, 2690, 63 >, -130, "", 0.1, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5282, -1081, 75 >, 180, "", 0.2, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5282, -1081, 75 >, 180, "", 0.9, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 3696, 2690, 63 >, -130, "", 0.8, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5282, -1081, 75 >, 180, "", 0.6, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5094, 2244, 63 >, -120, "", 0.4, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5398, 602, 67 >, -175, "", 0.6, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 5094, 2244, 63 >, -120, "", 0.3, "", 250.0 )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", < 3696, 2690, 63 >, -130, "", 0.5, "", 250.0 )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 6 )
	
	WaveSpawn_TitanSpawn( wave2, "Sniper", < 1794, -3238, 63 >, 90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave2, "Nuke", < -2821, 2958, 177 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave2, "Nuke", < -2492, 2478, 166 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave2, "Nuke", < -3110, 2296, 173 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave2, "Nuke", < 2823, -2989, 62 >, 130, "", 0.5 )
	WaveSpawn_TitanSpawn( wave2, "Nuke", < 1171, -3202, 61 >, 130, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave2, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave2, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse" )
	
    WaveSpawnEvents.append( wave2 )
	
	/*
	 __      __                 ____
	 \ \    / /__ _ __ __ ___  |__ /
	  \ \/\/ // _` |\ V // -_)  |_ \
	   \_/\_/ \__,_| \_/ \___| |___/
	
	*/
	array<WaveSpawnEvent> wave3
	WaveSpawn_TitanSpawn( wave3, "Nuke", < 26, 2704, 66 >, -110, "", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Nuke", < -3043, 3212, 202 >, -80, "", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Nuke", < 1880, 2993, 63 >, -120, "", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Nuke", < 2206, -3168, 63 >, 120, "", 5.0 )
	WaveSpawn_InfantrySpawn( wave3, "PodGrunt", < 1037, 713, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave3, "PodGrunt", < 1018, 251, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Ion", < -3012, 2126, 174 >, -70, "", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Ion", < 2788, -2821, 51 >, -70, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 6 )
	
	WaveSpawn_InfantrySpawn( wave3, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 2.0, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave3, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 0.5 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 6 )
	
	WaveSpawn_Announce( wave3, "PreMortarTitan", 0.0 )
	WaveSpawn_InfantrySpawn( wave3, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 3.0, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave3, "PodGrunt", < 2250, -3230, 63 >, 0.0, "eastBuildingsInfantry", 0.6 )
	WaveSpawn_InfantrySpawn( wave3, "PodGrunt", < 3894, 10, 72 >, 0.0, "desertBuildingsInfantry", 0.4 )
	WaveSpawn_InfantrySpawn( wave3, "DropshipGrunt", < 2294, -3422, 60 >, 128, "eastBuildingsInfantry", 0.3, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave3, "PodGrunt", < 3488, -9, 72 >, 0.0, "desertBuildingsInfantry", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 8 )
	
	WaveSpawn_TitanSpawn( wave3, "Monarch", < -2821, 2958, 177 >, -90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave3, "Monarch", < -2492, 2478, 166 >, -90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave3, "Monarch", < -3110, 2296, 173 >, -90, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 6 )
	
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 2355, 2510, 63 >, -90, "", 2.5, "fd_incTitansMortarClump" )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 4358, 194, 86 >, 45, "", 5.0 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 5259, -1537, 70 >, 170, "", 10.0 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 2.5 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 6.5 )
	WaveSpawn_InfantrySpawn( wave3, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 3.0, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave3, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 6 )
	
	WaveSpawn_Announce( wave3, "EliteTitans", 0.0 )
	WaveSpawn_TitanSpawn( wave3, "Ronin", < 4669, -801, 63 >, -35, "", 2.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave3, "Ronin", < 3270, 2807, 63 >, -80, "", 2.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave3, "Ronin", < -290, 3212, 86 >, -90, "", 15.0, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 0 )
	
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < -334, 3300, 90 >, -120, "", 1.5 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < -2243, 2107, 170 >, -105, "", 1.5 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < -3207, 1641, 165 >, -50, "", 1.5 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < -3012, 3221, 196 >, -50, "", 1.5 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < -592, 2003, 106 >, -33, "", 1.5 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < -329, 2625, 139 >, -90, "", 5.0 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < -3110, 2296, 173 >, -90, "", 2.5 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 2355, 2510, 63 >, -90, "", 2.5 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 4358, 194, 86 >, 45, "", 2.5 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 5259, -1537, 70 >, 170, "", 2.0 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < -2492, 2478, 166 >, -90, "", 1.0 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < -2821, 2958, 177 >, -90, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 4 )
	
	WaveSpawn_TitanSpawn( wave3, "Tone", < -2821, 2958, 177 >, -90, "", 1.0 )
	WaveSpawn_TitanSpawn( wave3, "Tone", < -2492, 2478, 166 >, -90, "", 1.0 )
	WaveSpawn_TitanSpawn( wave3, "Tone", < -3110, 2296, 173 >, -90, "", 3.0 )
	WaveSpawn_InfantrySpawn( wave3, "PodGrunt", < 2250, -3230, 63 >, 0.0, "eastBuildingsInfantry", 0.3 )
	WaveSpawn_InfantrySpawn( wave3, "PodGrunt", < 3894, 10, 72 >, 0.0, "desertBuildingsInfantry", 0.2 )
	WaveSpawn_InfantrySpawn( wave3, "DropshipGrunt", < 2294, -3422, 60 >, 128, "eastBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave3, "PodGrunt", < 3488, -9, 72 >, 0.0, "desertBuildingsInfantry" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 8 )
	
	WaveSpawn_ReaperSpawn( wave3, "TickReaper", < 2168, 1630, 208 >, 0, "", 2.0, "fd_waveTypeReaperTicks" )
	WaveSpawn_ReaperSpawn( wave3, "TickReaper", < 1871, 3091, 68 >, -90, "", 0.7 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < 1752, -2198, 72 >, 13, "", 2.0 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < 2446, -2651, 72 >, -36, "", 1.5 )
	WaveSpawn_ReaperSpawn( wave3, "TickReaper", < -1120, 1801, 153 >, 0, "", 0.8 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < 3871, -1098, 63 >, -17, "", 0.7 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", < 955, 1810, 82 >, -50, "", 1.0 )
	WaveSpawn_ReaperSpawn( wave3, "TickReaper", < -2003, 3501, 108 >, -90, "", 5.0 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 4358, 194, 86 >, 45, "", 1.5 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 2355, 2510, 63 >, -90, "", 2.0 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < -3110, 2296, 173 >, -90, "", 1.5 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < -2821, 2958, 177 >, -90, "", 1.2 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 5259, -1537, 70 >, 170, "", 1.0 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < -2492, 2478, 166 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 2781, -3066, 62 >, 106, "", 1.5 )
	WaveSpawn_TitanSpawn( wave3, "Mortar", < 1654, -3257, 63 >, 106, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 8 )
	
	WaveSpawn_TitanSpawn( wave3, "Nuke", < 26, 2704, 66 >, -110, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 0.5 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Nuke", < 2206, -3168, 63 >, 120, "", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Nuke", < 1880, 2993, 63 >, -120, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave3, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_TitanSpawn( wave3, "Nuke", < -3043, 3212, 202 >, -80, "" )
	
    WaveSpawnEvents.append( wave3 )
	
	/*
	 __      __                 _ _  
	 \ \    / /__ _ __ __ ___  | | | 
	  \ \/\/ // _` |\ V // -_) |_  _|
	   \_/\_/ \__,_| \_/ \___|   |_| 
	
	*/
	array<WaveSpawnEvent> wave4
	WaveSpawn_InfantrySpawn( wave4, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave4, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_TitanSpawn( wave4, "Legion", < -56, 3040, 71 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Monarch", < 5691, -908, 73 >, 150, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Legion", < 5308, -1382, 76 >, 150, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Monarch", < -3020, 3082, 196 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_Announce( wave4, "PreNukeTitan", 0.0 )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 2 )
	
	WaveSpawn_TitanSpawn( wave4, "Ion", < 26, 2704, 66 >, -110, "", 0.3 )
	WaveSpawn_TitanSpawn( wave4, "Ion", < -3043, 3212, 202 >, -80, "", 2.5 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < 3488, -9, 72 >, 0.0, "desertBuildingsInfantry", 0.4 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < 3894, 10, 72 >, 0.0, "desertBuildingsInfantry", 0.3 )
	WaveSpawn_InfantrySpawn( wave4, "DropshipGrunt", < 2294, -3422, 60 >, 128, "eastBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < 2250, -3230, 63 >, 0.0, "eastBuildingsInfantry", 3.0 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 2206, -3168, 63 >, 120, "", 0.6, "fd_waveTypeTitanNuke" )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 1880, 2993, 63 >, -120, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 2 )
	
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -3110, 2296, 173 >, -90, "", 0.6 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 2355, 2510, 63 >, -90, "", 0.6 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 4358, 194, 86 >, 45, "", 0.6 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 5259, -1537, 70 >, 170, "", 0.6 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -2492, 2478, 166 >, -90, "", 0.6 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -2821, 2958, 177 >, -90, "", 3.5 )
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < 1076, -543, 68 >, 90, "", 0.5 )
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < 3852, -1136, 64 >, -45, "", 2.5 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < -3465, 347, 69 >, 0.0, "", 0.6 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < 2713, -2322, 63 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < 1722, -953, 68 >, 0.0, "", 0.4 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < 1258, 2072, 71 >, 0.0, "", 0.3 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < 1263, 1526, 68 >, 0.0, "", 0.2 )
	WaveSpawn_InfantrySpawn( wave4, "PodGrunt", < -926, 2268, 130 >, 0.0, "", 0.5 )
	WaveSpawn_Announce( wave4, "PreArcTitan", 0.0 )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_InfantrySpawn( wave4, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave4, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 3.5 )
	WaveSpawn_TitanSpawn( wave4, "Mortar", < 2802, -3074, 63 >, 120, "", 0.4 )
	WaveSpawn_TitanSpawn( wave4, "Mortar", < 3208, -1837, 64 >, 130, "", 0.4 )
	WaveSpawn_TitanSpawn( wave4, "Mortar", < 5728, -940, 72 >, 150, "", 1.0 )
	WaveSpawn_TitanSpawn( wave4, "Northstar", < 1794, -3238, 63 >, 90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < -2849, 2976, 178 >, -90, "", 0.5, "fd_waveTypeTitanArc" )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -3178, 2650, 178 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -2445, 2638, 159 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -2463, 3278, 154 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -3090, 3276, 210 >, -90, "", 5.0 )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < 5134, -1041, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 4925, -1366, 71 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 4894, -767, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 5509, -812, 86 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 5659, -1337, 69 >, -180, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < 2439, -2637, 72 >, -90, "", 0.5 )
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < -1649, 934, 64 >, -90, "", 0.5 )
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < -998, 3442, 101 >, -90, "", 0.5 )
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < -579, 2058, 108 >, -90, "", 0.5 )
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < -1616, 2170, 138 >, -90, "", 0.5 )
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < 1502, 1290, 73 >, 180, "", 1.5 )
	WaveSpawn_InfantrySpawn( wave4, "Spectre", < 3488, -9, 72 >, 0.0, "desertBuildingsInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave4, "Spectre", < 3894, 10, 72 >, 0.0, "desertBuildingsInfantry", 3.0 )
	WaveSpawn_TitanSpawn( wave4, "Ion", < 1676, 2623, 67 >, -120, "", 3.0, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Ion", < -2770, 3354, 177 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_InfantrySpawn( wave4, "DropshipGrunt", < 2294, -3422, 60 >, 128, "eastBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave4, "Spectre", < 2250, -3230, 63 >, 0.0, "eastBuildingsInfantry", 5.0 )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < -2821, 2958, 177 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < -2492, 2478, 166 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < -3110, 2296, 173 >, -90, "", 3.0 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 4906, 2529, 63 >, -140, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 4205, 2848, 63 >, -150, "", 0.6 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 5509, 1995, 68 >, -145, "", 0.7 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 5723, 1290, 73 >, -170, "", 1.0 )
	WaveSpawn_TitanSpawn( wave4, "Scorch", < 4080, 513, 65 >, 70, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Ion", < 1686, 2594, 64 >, -70, "", 3.0 )
	WaveSpawn_InfantrySpawn( wave4, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave4, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse" )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -2821, 2958, 177 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -2492, 2478, 166 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < -3110, 2296, 173 >, -90, "", 5.0 )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < 4906, 2529, 63 >, -140, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < 4205, 2848, 63 >, -150, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < 5509, 1995, 68 >, -145, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", < 5723, 1290, 73 >, -170, "", 5.0 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 2802, -3074, 63 >, 120, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 3208, -1837, 64 >, 130, "", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Nuke", < 5728, -940, 72 >, 150, "", 5.0 )
	WaveSpawn_InfantrySpawn( wave4, "Spectre", < 1037, 713, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave4, "Spectre", < 1442, 411, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave4, "Spectre", < 1018, 251, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_TitanSpawn( wave4, "Northstar", < -583, 1988, 104 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Northstar", < 1087, -1324, 64 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	
    WaveSpawnEvents.append( wave4 )
	
	/*
	 __      __                 ___ 
	 \ \    / /__ _ __ __ ___  | __|
	  \ \/\/ // _` |\ V // -_) |__ \
	   \_/\_/ \__,_| \_/ \___| |___/
	
	*/
	array<WaveSpawnEvent> wave5
	WaveSpawn_Announce( wave5, "MediumWave", 0.0 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < -2821, 2958, 177 >, -90, "", 0.3 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < -2492, 2478, 166 >, -90, "", 0.3 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < -3110, 2296, 173 >, -90, "", 2.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 2802, -3074, 63 >, 120, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 3208, -1837, 64 >, 130, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 5728, -940, 72 >, 150, "", 3.0 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < 1244, 1523, 69 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < 3300, 2808, 64 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < 3858, -69, 72 >, 0.0, "", 2.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 4906, 2529, 63 >, -140, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < 4205, 2848, 63 >, -150, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 5509, 1995, 68 >, -145, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < 5723, 1290, 73 >, -170, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 3208, 3315, 120 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 3901, -1129, 63 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 2 )
	
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 4358, 194, 86 >, 45, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 2355, 2510, 63 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < -3110, 2296, 173 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2821, 2958, 177 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 5259, -1537, 70 >, 170, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2492, 2478, 166 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 2781, -3066, 62 >, 106, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 1654, -3257, 63 >, 106, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 2.0 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2821, 2958, 177 >, -90, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -329, 2625, 139 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2492, 2478, 166 >, -90, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -334, 3300, 90 >, -120, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -3110, 2296, 173 >, -90, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -3012, 3221, 196 >, -50, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 2802, -3074, 63 >, 120, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -3207, 1641, 165 >, -50, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 3208, -1837, 64 >, 130, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -592, 2003, 106 >, -33, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 5728, -940, 72 >, 150, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -2243, 2107, 170 >, -105, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_Announce( wave5, "Everything", 0.0 )
	WaveSpawn_InfantrySpawn( wave5, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 1.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave5, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 5.0, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 1018, 251, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 1037, 713, 67 >, 0.0, "acrossAvenueInfantry", 6.0 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < -954, 2545, 147 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < -508, 890, 72 >, 0.0, "", 1.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 2.0 )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 1255, -1327, 64 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 2802, -3074, 63 >, 120, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 1798, -2103, 71 >, 90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 3208, -1837, 64 >, 130, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 1239, 2223, 64 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 5728, -940, 72 >, 150, "", 7.0 )
	WaveSpawn_TitanSpawn( wave5, "Scorch", < 5134, -1041, 65 >, -180, "", 2.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Ion", < 4925, -1366, 71 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < 4894, -767, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Tone", < 5509, -812, 86 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Tone", < 5659, -1337, 69 >, -180, "", 2.5 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 1037, 713, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 1018, 251, 67 >, 0.0, "acrossAvenueInfantry", 0.3 )
	WaveSpawn_InfantrySpawn( wave5, "DropshipGrunt", < 2294, -3422, 60 >, 128, "eastBuildingsInfantry", 0.2, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 2250, -3230, 63 >, 0.0, "eastBuildingsInfantry", 0.4 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < 2871, 624, 72 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < 2496, 1420, 73 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 4925, -1366, 71 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2463, 3278, 154 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 5509, -812, 86 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2445, 2638, 159 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -3178, 2650, 178 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 5659, -1337, 69 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -3090, 3276, 210 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 5134, -1041, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 4894, -767, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2849, 2976, 178 >, -90, "", 2.5 )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", < -3860, 225, 17 >, 0.0, "", 0.6 )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", < -3465, 347, 69 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", < -3864, -395, -14 >, 0.0, "", 0.4 )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_TitanSpawn( wave5, "Monarch", < -3110, 2296, 173 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Tone", < 2355, 2510, 63 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < 4358, 194, 86 >, 45, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Tone", < 5259, -1537, 70 >, 170, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < -2492, 2478, 166 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < -2821, 2958, 177 >, -90, "", 15.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 2802, -3074, 63 >, 120, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 3208, -1837, 64 >, 130, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 5728, -940, 72 >, 150, "", 5.0 )
	WaveSpawn_InfantrySpawn( wave5, "DropshipGrunt", < 3616, 2173, 63 >, -165, "desertBuildingsInfantry", 1.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < -578, 1976, 104 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < -2008, 3479, 109 >, -90, "", 2.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 1442, 411, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "DropshipGrunt", < 2294, -3422, 60 >, 128, "eastBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 3894, 10, 72 >, 0.0, "desertBuildingsInfantry" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 1502, 1290, 73 >, -180, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -2463, 3278, 154 >, -90, "", 2.5 )
	WaveSpawn_TitanSpawn( wave5, "Legion", < -2849, 2976, 178 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Tone", < -3178, 2650, 178 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Tone", < -2445, 2638, 159 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < -2463, 3278, 154 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < -3090, 3276, 210 >, -90, "", 2.5 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 1102, -544, 68 >, 90, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -3090, 3276, 210 >, -90, "", 2.5 )
	WaveSpawn_TitanSpawn( wave5, "Scorch", < 5134, -1041, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 4925, -1366, 71 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 4894, -767, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < 5509, -812, 86 >, -180, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < 5659, -1337, 69 >, -180, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_InfantrySpawn( wave5, "DropshipGrunt", < 4636, 613, 78 >, 115, "desertBuildingsInfantry", 2.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 1442, 411, 67 >, 0.0, "acrossAvenueInfantry", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "DropshipGrunt", < 2294, -3422, 60 >, 128, "eastBuildingsInfantry", 0.5, "", 0.0, eFDSD.ALL, 6 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < 3894, 10, 72 >, 0.0, "desertBuildingsInfantry", 20.0 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < -290, 3212, 86 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 1794, -3238, 63 >, 90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 3270, 2807, 63 >, -80, "", 2.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 5509, 1995, 68 >, -145, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 5723, 1290, 73 >, -170, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -3110, 2296, 173 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2492, 2478, 166 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2821, 2958, 177 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 4906, 2529, 63 >, -140, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 4205, 2848, 63 >, -150, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -2940, 2860, 179 >, -175, "", 0.5, "", 300.0 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < -1924, 2972, 140 >, -90, "", 0.4 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < -1656, 937, 63 >, -90, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < 1858, 2390, 107 >, -130, "", 0.3, "", 300.0 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < 5351, -1142, 78 >, -120, "", 0.2, "", 500.0 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < -2940, 2860, 179 >, -175, "", 0.1, "", 300.0 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < 1834, -3029, 51 >, 180, "", 0.2, "", 300.0 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 1874, 3097, 68 >, -90, "", 0.1 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 1504, 1281, 72 >, 180, "", 0.2 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < 1834, -3029, 51 >, 180, "", 0.3, "", 300.0 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < 1858, 2390, 107 >, -130, "", 0.4, "", 300.0 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < 1834, -3029, 51 >, 180, "", 0.3, "", 300.0 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < 5351, -1142, 78 >, -120, "", 0.2, "", 500.0 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < -1622, 2190, 139 >, -90, "", 0.4 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < -828, 2434, 139 >, -90, "", 0.6 )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", < 1858, 2390, 107 >, -130, "", 0.5, "", 300.0 )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 3939, -1172, 66 >, -45, "", 1.0 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -3138, 2795, 185 >, -90, "", 0.9 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 1761, -3296, 64 >, 90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2690, 2887, 184 >, -90, "", 0.7 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < -313, 2878, 171 >, 90, "", 0.6 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2900, 2647, 183 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < -2920, 3432, 185 >, 90, "", 0.4 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 2752, -3041, 59 >, 135, "", 0.3 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 1863, 2974, 64 >, 90, "", 0.2 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 2197, -3153, 64 >, 135, "", 0.3 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 5887, 1325, 65 >, 180, "", 0.4 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 1776, -3251, 64 >, 135, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 5752, -868, 74 >, 180, "", 0.6 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 1724, 2524, 64 >, -90, "", 0.7 )
	WaveSpawn_TitanSpawn( wave5, "Mortar", < 3317, 2818, 65 >, -90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 1724, 2524, 64 >, -90, "", 0.9 )
	WaveSpawn_TitanSpawn( wave5, "Ronin", < -299, 3186, 88 >, -90, "", 1.0, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Ronin", < 5287, -1442, 75 >, 180, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < -954, 2545, 147 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < -508, 890, 72 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < 2871, 624, 72 >, 0.0, "", 0.5 )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < 2496, 1420, 73 >, 0.0, "" )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_TitanSpawn( wave5, "Scorch", < 4906, 2529, 63 >, -140, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Legion", < 4205, 2848, 63 >, -150, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Scorch", < 5509, 1995, 68 >, -145, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Legion", < 5723, 1290, 73 >, -170, "", 2.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 2.5 )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 3208, 3315, 120 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 3901, -1129, 63 >, -90, "", 2.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < -2821, 2958, 177 >, -90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < -2492, 2478, 166 >, -90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < -3110, 2296, 173 >, -90, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneMain", 2.5 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 1375, -2688, 72 >, -90, "", 1.5 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 4283, 97, 73 >, 0, "", 1.5 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 3179, 3270, 120 >, -90, "", 1.5 )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < -3465, 347, 69 >, 0.0, "", 0.3 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < -3864, -395, -14 >, 0.0, "", 0.6 )
	WaveSpawn_InfantrySpawn( wave5, "Spectre", < -3860, 225, 17 >, 0.0, "", 0.9 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 4925, -1366, 71 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < -2463, 3278, 154 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 5509, -812, 86 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < -2445, 2638, 159 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < -3178, 2650, 178 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 5659, -1337, 69 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < -3090, 3276, 210 >, -90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 5134, -1041, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 4894, -767, 65 >, -180, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < -2849, 2976, 178 >, -90, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_TitanSpawn( wave5, "Tone", < 1488, -3028, 46 >, 90, "", 1.2 )
	WaveSpawn_TitanSpawn( wave5, "Legion", < 5708, 605, 64 >, 180, "", 1.1 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 4849, 2438, 66 >, -135, "", 1.0 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < 2343, 2514, 64 >, -90, "", 0.9 )
	WaveSpawn_TitanSpawn( wave5, "Scorch", < -247, 3318, 88 >, -90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < 1758, 2612, 64 >, -90, "", 0.7 )
	WaveSpawn_TitanSpawn( wave5, "Legion", < 5461, 871, 70 >, 180, "", 0.6 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 4326, 2382, 66 >, -135, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Scorch", < -448, 3065, 106 >, -90, "", 0.4 )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", < 5098, 2024, 67 >, -135, "", 0.3 )
	WaveSpawn_TitanSpawn( wave5, "Scorch", < -39, 2842, 75 >, -90, "", 0.2 )
	WaveSpawn_TitanSpawn( wave5, "Tone", < 1181, -3190, 62 >, 90, "", 0.2 )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < -2899, 2989, 182 >, -90, "", 0.3 )
	WaveSpawn_TitanSpawn( wave5, "Ronin", < 5720, -1306, 71 >, 180, "", 0.4 )
	WaveSpawn_TitanSpawn( wave5, "Tone", < 1344, -3664, 115 >, 90, "", 0.5 )
	WaveSpawn_TitanSpawn( wave5, "Ronin", < 5107, -1522, 69 >, 180, "", 0.6 )
	WaveSpawn_TitanSpawn( wave5, "Legion", < 5770, 1266, 74 >, 180, "", 0.7 )
	WaveSpawn_TitanSpawn( wave5, "Ion", < 1263, 2179, 63 >, -90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < -2636, 2894, 179 >, -90, "", 0.9 )
	WaveSpawn_TitanSpawn( wave5, "Ronin", < 5797, -980, 74 >, 180, "", 1.0 )
	WaveSpawn_TitanSpawn( wave5, "Monarch", < -3162, 2800, 188 >, -90, "", 1.1 )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -3138, 2795, 185 >, -90, "", 1.2 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2690, 2887, 184 >, -90, "", 1.0 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < -2900, 2647, 183 >, -90, "", 0.8 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 2752, -3041, 59 >, 135, "", 0.6 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 2197, -3153, 64 >, 135, "", 0.4 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 1776, -3251, 64 >, 135, "", 0.2 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 1724, 2524, 64 >, -90, "", 0.4 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", < 1724, 2524, 64 >, -90, "", 0.6 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 1077, -534, 68 >, 90, "", 0.8 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 1791, 1763, 208 >, 90, "", 1.0 )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < -2171, 901, 57 >, 0, "", 2.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Drones", < 2764, 1218, 2580 >, 0.0, "droneReverse", 1.0 )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_TitanSpawn( wave5, "Tone", < -56, 3040, 71 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Tone", < 5691, -908, 73 >, 150, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Tone", < 5308, -1382, 76 >, 150, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Tone", < -3020, 3082, 196 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 1255, -1327, 64 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 1798, -2103, 71 >, 90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", < 1239, 2223, 64 >, -90, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	
    WaveSpawnEvents.append( wave5 )
}

void function RegisterCustomFDContent()
{
	array<entity> dropshipSpawns = GetEntArrayByClass_Expensive( "info_spawnpoint_dropship_start" )
	foreach ( entity dropshipSpawn in dropshipSpawns )
		dropshipSpawn.Destroy()
	
	AddFDCustomShipStart( < -2141, -1595, 640 >, < 0, 75, 0 >, TEAM_MILITIA )
	AddFDCustomShipStart( < -1261, -1836, 640 >, < 0, 90, 0 >, TEAM_MILITIA )
	AddFDCustomShipStart( < 3598, 2129, 640 >, < 0, -140, 0 >, TEAM_IMC )
	AddFDCustomShipStart( < 4871, 784, 640 >, < 0, 180, 0 >, TEAM_IMC )
	
	AddFDCustomTitanStart( < -1193, -1134, 50 >, < 0, 45, 0 > )
	AddFDCustomTitanStart( < -1168, -2390, 84 >, < 0, 135, 0 > )
	
	SpawnFDHeavyTurret( < -2376, -1000, 207 >, < 0, 0, 0 >, < -2556, -1027, 208 >, < 0, -90, 0 > )
	
	AddFDCustomProp( $"models/kodai_live_fire/live_fire_wall_01.mdl", < -910, -1915, 175 >, < 0, 180, 0 > )
	AddFDCustomProp( $"models/kodai_live_fire/live_fire_wall_01.mdl", < -910, -2091, 175 >, < 0, 180, 0 > )
	
	AddFDCustomProp( $"models/kodai_live_fire/live_fire_wall_01.mdl", < 1566, -945, 273 >, < 0, 180, 0 > )
	AddFDCustomProp( $"models/kodai_live_fire/live_fire_wall_01.mdl", < 1566, -1121, 273 >, < 0, 180, 0 > )
	
	AddFDCustomProp( $"models/kodai_live_fire/live_fire_wall_01.mdl", < 897, 109, 67 >, < 0, 90, 0 > )
	AddFDCustomProp( $"models/kodai_live_fire/live_fire_wall_01.mdl", < 1074, 109, 67 >, < 0, 90, 0 > )
	AddFDCustomProp( $"models/kodai_live_fire/live_fire_wall_01.mdl", < 1251, 109, 67 >, < 0, 90, 0 > )
	AddFDCustomProp( $"models/kodai_live_fire/live_fire_wall_01.mdl", < 1428, 109, 67 >, < 0, 90, 0 > )
	
	AddFDCustomProp( $"models/imc_base/cargo_container_imc_01_blue.mdl", < 63, -1126, 204 >, < 0, 0, 0 > )
	AddFDCustomProp( $"models/imc_base/cargo_container_imc_01_blue.mdl", < 189, -1126, 204 >, < 0, 0, 0 > )
	
	AddFDCustomProp( $"models/imc_base/cargo_container_imc_01_blue.mdl", < 632, 142, 216 >, < 0, 90, 0 > )
	AddFDCustomProp( $"models/imc_base/cargo_container_imc_01_blue.mdl", < 632, 268, 216 >, < 0, -90, 0 > )
	
	AddFDCustomProp( $"models/imc_base/cargo_container_imc_01_blue.mdl", < -921, -2244, 176 >, < 0, 90, 0 > )
	AddFDCustomProp( $"models/imc_base/cargo_container_imc_01_blue.mdl", < -921, -2244, 272 >, < 0, -90, 0 > )
	AddFDCustomProp( $"models/imc_base/cargo_container_imc_01_blue.mdl", < -921, -2370, 176 >, < 0, 90, 0 > )
	
	AddFDCustomProp( $"models/barriers/sandbags_curved_01.mdl", < 475, -1463, 203 >, < 0, 0, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_curved_01.mdl", < 26, -1272, 203 >, < 0, 0, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_curved_01.mdl", < 761, -1382, 203 >, < 0, 90, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_large_01.mdl", < 627, -1461, 203 >, < 0, 0, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_large_01.mdl", < 512, -1461, 203 >, < 0, 0, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_large_01.mdl", < 79, -1265, 203 >, < 0, 0, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_large_01.mdl", < 193, -1265, 203 >, < 0, 0, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_large_01.mdl", < 307, -1265, 203 >, < 0, 0, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_large_01.mdl", < 394, -1330, 204 >, < 0, -90, 0 > )
	AddFDCustomProp( $"models/barriers/sandbags_large_01.mdl", < 754, -1326, 204 >, < 0, 90, 0 > )
	
	AddStationaryAIPosition( < 2285, 3317, 287 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 1776, 1484, 401 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 1706, -666, 332 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < -1333, 1967, 457 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < -1850, 1870, 449 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < -1654, 2784, 492 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < -2160, 620, 349 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 4005, -483, 634 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 1459, -2331, 332 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	
	AddStationaryAIPosition( < 4227, -184, 602 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 1777, 1220, 440 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 1027, 659, 67 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 1452, 357, 67 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < -2210, 3048, 417 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < -1318, 2393, 304 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 3194, 25, 340 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 3194, 25, 340 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < -3271, 97, 105 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < -2150, 1149, 349 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 2748, -1323, 328 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 2338, -2356, 368 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 2791, 3242, 288 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	
	AddStationaryAIPosition( < 4089, 2935, 63 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 5544, 2048, 63 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 5343, 461, 67 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 5638, -868, 87 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 4571, -1669, 77 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 2486, -3365, 86 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 1740, -3293, 63 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < -619, 3283, 100 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < -1475, 3428, 135 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < -200, 3111, 87 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 1881, 2785, 63 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 2012, -3649, 87 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	
	AddStationaryAIPosition( < -254, -1140, 65 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < -2828, 3428, 179 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 5434, -1327, 66 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 2721, 2337, 63 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 814, -3528, 101 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < -1116, 1489, 78 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 2518, -55, 65 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 2441, -1795, 66 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 4767, 1619, 176 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	
	routes[ "leftRoadMain" ] <- []
	routes[ "leftRoadMain" ].append( < -2774, 2067, 173 > )
	routes[ "leftRoadMain" ].append( < -2544, 269, 72 > )
	routes[ "leftRoadMain" ].append( < -1893, -677, 176 > )
	routes[ "leftRoadMain" ].append( < -2095, -1708, 52 > )
	
	routes[ "roadDesertMain" ] <- []
	routes[ "roadDesertMain" ].append( < 2636, 1113, 61 > )
	routes[ "roadDesertMain" ].append( < 2488, -172, 63 > )
	routes[ "roadDesertMain" ].append( < -283, -177, 57 > )
	routes[ "roadDesertMain" ].append( < -1609, -671, 182 > )
	routes[ "roadDesertMain" ].append( < -1172, -1477, 77 > )
	
	routes[ "eastDesertRoadMain" ] <- []
	routes[ "eastDesertRoadMain" ].append( < 4285, -1363, 65 > )
	routes[ "eastDesertRoadMain" ].append( < 809, -1753, 63 > )
	routes[ "eastDesertRoadMain" ].append( < -1121, -1697, 84 > )
	
	routes[ "westRoadFlank" ] <- []
	routes[ "westRoadFlank" ].append( < 1353, 2090, 64 > )
	routes[ "westRoadFlank" ].append( < 430, 1288, 56 > )
	routes[ "westRoadFlank" ].append( < -1038, 1302, 66 > )
	routes[ "westRoadFlank" ].append( < -1579, -670, 176 > )
	routes[ "westRoadFlank" ].append( < -2095, -1708, 52 > )
	
	routes[ "cliffsideRoad" ] <- []
	routes[ "cliffsideRoad" ].append( < -258, 3033, 108 > )
	routes[ "cliffsideRoad" ].append( < -357, 1473, 66 > )
	routes[ "cliffsideRoad" ].append( < -1295, 303, 63 > )
	routes[ "cliffsideRoad" ].append( < -1596, -673, 176 > )
	routes[ "cliffsideRoad" ].append( < -1210, -1604, 90 > )
	
	routes[ "southRoadInfantry" ] <- []
	routes[ "southRoadInfantry" ].append( < -3253, 567, 54 > )
	routes[ "southRoadInfantry" ].append( < -2414, 48, 61 > )
	routes[ "southRoadInfantry" ].append( < -2503, -923, 72 > )
	routes[ "southRoadInfantry" ].append( < -2426, -1864, 72 > )
	
	routes[ "desertBuildingsInfantry" ] <- []
	routes[ "desertBuildingsInfantry" ].append( < 2498, 623, 63 > )
	routes[ "desertBuildingsInfantry" ].append( < 2069, 460, 72 > )
	routes[ "desertBuildingsInfantry" ].append( < 282, 326, 72 > )
	routes[ "desertBuildingsInfantry" ].append( < -641, -191, 63 > )
	routes[ "desertBuildingsInfantry" ].append( < -881, -717, 208 > )
	routes[ "desertBuildingsInfantry" ].append( < -955, -1058, 208 > )
	
	routes[ "eastBuildingsInfantry" ] <- []
	routes[ "eastBuildingsInfantry" ].append( < 2335, -907, 63 > )
	routes[ "eastBuildingsInfantry" ].append( < 1430, -980, 68 > )
	routes[ "eastBuildingsInfantry" ].append( < 509, -1270, 68 > )
	routes[ "eastBuildingsInfantry" ].append( < -955, -1058, 208 > )
	
	routes[ "desertDeepMainAvenue" ] <- []
	routes[ "desertDeepMainAvenue" ].append( < 4804, 1470, 92 > )
	routes[ "desertDeepMainAvenue" ].append( < 2489, 912, 58 > )
	routes[ "desertDeepMainAvenue" ].append( < 2456, -95, 63 > )
	routes[ "desertDeepMainAvenue" ].append( < -281, -269, 56 > )
	routes[ "desertDeepMainAvenue" ].append( < -1892, -673, 176 > )
	routes[ "desertDeepMainAvenue" ].append( < -2112, -1688, 51 > )
	
	routes[ "eastCrates" ] <- []
	routes[ "eastCrates" ].append( < 1828, -3108, 45 > )
	routes[ "eastCrates" ].append( < 921, -1737, 63 > )
	routes[ "eastCrates" ].append( < -1145, -1660, 85 > )
	
	routes[ "droneMain" ] <- []
	routes[ "droneMain" ].append( < 2397, 749, 422 > )
	routes[ "droneMain" ].append( < 2466, -406, 422 > )
	routes[ "droneMain" ].append( < 2127, -1621, 63 > )
	routes[ "droneMain" ].append( < -788, -1832, 81 > )
	routes[ "droneMain" ].append( < -1743, -978, 72 > )
	routes[ "droneMain" ].append( < -1511, -181, 422 > )
	routes[ "droneMain" ].append( < -1178, 970, 60 > )
	routes[ "droneMain" ].append( < -382, 1526, 67 > )
	routes[ "droneMain" ].append( < 802, 1257, 55 > )
	routes[ "droneMain" ].append( < 1580, 933, 56 > )
	
	routes[ "droneReverse" ] <- []
	routes[ "droneReverse" ].append( < 2397, 749, 422 > )
	routes[ "droneReverse" ].append( < 1580, 933, 56 > )
	routes[ "droneReverse" ].append( < 802, 1257, 55 > )
	routes[ "droneReverse" ].append( < -382, 1526, 67 > )
	routes[ "droneReverse" ].append( < -1178, 970, 60 > )
	routes[ "droneReverse" ].append( < -1511, -181, 422 > )
	routes[ "droneReverse" ].append( < -1743, -978, 72 > )
	routes[ "droneReverse" ].append( < -788, -1832, 81 > )
	routes[ "droneReverse" ].append( < 2127, -1621, 63 > )
	routes[ "droneReverse" ].append( < 2466, -406, 422 > )
	
	routes[ "acrossAvenueInfantry" ] <- []
	routes[ "acrossAvenueInfantry" ].append( < 2486, 465, 63 > )
	routes[ "acrossAvenueInfantry" ].append( < 1433, 461, 67 > )
	routes[ "acrossAvenueInfantry" ].append( < 484, 438, 67 > )
	routes[ "acrossAvenueInfantry" ].append( < 663, -556, 68 > )
	routes[ "acrossAvenueInfantry" ].append( < 139, -629, 204 > )
	routes[ "acrossAvenueInfantry" ].append( < 58, -1195, 68 > )
	routes[ "acrossAvenueInfantry" ].append( < -955, -1058, 208 > )
}