global function initFrontierDefenseData
void function initFrontierDefenseData()
{
	useCustomFDLoad = true
	AddCallback_RegisterCustomFDContent( RegisterCustomFDContent )
    PlaceFDShop( < -2811, -1176, 128 > )
	SetFDDropshipSpawn( < -2616, -496, 48 > )
	SetFDGroundSpawn( < -3126, -1181, 129 > )
	
	AddFDDropPodSpawn( < -2906, -265, 264 > )
	AddFDDropPodSpawn( < -4569, -647, 314 > )
	AddFDDropPodSpawn( < -2950, -1857, 268 > )
	
	AddWaveAnnouncement( "fd_introMedium" )
	AddWaveAnnouncement( "fd_waveTypeReaperTicks" )
	AddWaveAnnouncement( "fd_waveTypeCloakDrone" )
	AddWaveAnnouncement( "fd_introHard" )
	AddWaveAnnouncement( "fd_waveComboNukeTrain" )

	array<vector> infantrySpawns = []
	infantrySpawns.append( < -606, -362, 3 > )
	infantrySpawns.append( < -169, -800, -1 > )
	infantrySpawns.append( < -1092, -1299, 37 > )
	infantrySpawns.append( < -1747, -311, 272 > )
	infantrySpawns.append( < -1261, -121, 272 > )
	infantrySpawns.append( < 563, -825, 54 > )
	infantrySpawns.append( < -209, 1078, -1 > )
	infantrySpawns.append( < -965, 1076, 53 > )
	infantrySpawns.append( < 1171, 408, 272 > )
	infantrySpawns.append( < 1312, 665, 267 > )
	infantrySpawns.append( < 1432, 1419, 271 > )
	infantrySpawns.append( < 289, 676, 0 > )
	
	array<vector> reaperSpawns = []
	reaperSpawns.append( < 1666, 1392, 272 > )
	reaperSpawns.append( < 2429, 1435, 127 > )
	reaperSpawns.append( < 1224, 509, 272 > )
	reaperSpawns.append( < 3747, 2084, 37 > )
	reaperSpawns.append( < 3674, -217, 29 > )
	reaperSpawns.append( < 3185, 1131, 0 > )
	reaperSpawns.append( < 427, 2277, 15 > )
	reaperSpawns.append( < 565, -1294, 5 > )
	reaperSpawns.append( < 3211, 2594, 19 > )
	reaperSpawns.append( < -571, -178, 0 > )
	
	array<vector> titanSpawns = []
	titanSpawns.append( < 3543, 2036, 14 > )
	titanSpawns.append( < 3638, 1175, -10 > )
	titanSpawns.append( < 3188, 628, 30 > )
	titanSpawns.append( < 3472, 343, 13 > )
	titanSpawns.append( < 3315, -171, 23 > )
	titanSpawns.append( < 2134, -608, 48 > )
	titanSpawns.append( < 3146, 2516, -4 > )
	titanSpawns.append( < 2178, 2187, 90 > )
	titanSpawns.append( < 2356, 2545, 30 > )
	titanSpawns.append( < 3670, 883, 5 > )
	titanSpawns.append( < 3217, 1705, 19 > )
	
	array<vector> specialTitanSpawns = []
	specialTitanSpawns.append( < 1972, 993, 17 > )
	specialTitanSpawns.append( < 2663, -1, 33 > )
	specialTitanSpawns.append( < 1369, 2576, 63 > )
	specialTitanSpawns.append( < 1889, 2242, 102 > )
	specialTitanSpawns.append( < 3277, 2127, 17 > )
	specialTitanSpawns.append( < 478, 2205, 3 > )
	
	/*
	 __      __                 _ 
	 \ \    / /__ _ __ __ ___  / |
	  \ \/\/ // _` |\ V // -_) | |
	   \_/\_/ \__,_| \_/ \___| |_|
	
	*/
    array<WaveSpawnEvent> wave1
	WaveSpawn_SmokeWall( wave1, < -177, 1610, 2 >, 1.0 )
	WaveSpawn_SmokeWall( wave1, < -2243, 931, 34 >, 0.8 )
	WaveSpawn_SmokeWall( wave1, < -2287, -667, 18 >, 0.6 )
	WaveSpawn_SmokeWall( wave1, < -1179, -884, -13 >, 0.4 )
	WaveSpawn_SmokeWall( wave1, < -1887, -1701, 61 >, 0.2 )
	WaveSpawn_SmokeWall( wave1, < -3135, 350, 18 >, 2.5 )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ), "fd_waveTypeInfantry" )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 6 )
	
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 6 )
	
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ), "fd_waveTypeStalkers" )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 6 )
	
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ), "fd_waveTypeMortarSpectre" )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 8 )
	
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave1, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave1, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_WaitEnemyAliveAmount( wave1, 8 )
	
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave1, "Stalker", infantrySpawns.getrandom(), 0.0, "" )
	
    WaveSpawnEvents.append( wave1 )
	
	/*
	 __      __                 ___ 
	 \ \    / /__ _ __ __ ___  |_  )
	  \ \/\/ // _` |\ V // -_)  / / 
	   \_/\_/ \__,_| \_/ \___| /___|
	
	*/
	array<WaveSpawnEvent> wave2
	WaveSpawn_TitanSpawn( wave2, "Monarch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ), "fd_waveTypeTitanReg" )
	WaveSpawn_TitanSpawn( wave2, "Monarch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave2, "Monarch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 4 )
	
	WaveSpawn_TitanSpawn( wave2, "Tone", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave2, "Ion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave2, "Ion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 4 )
	
	WaveSpawn_TitanSpawn( wave2, "Legion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave2, "Ronin", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave2, "Ronin", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 4 )
	
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ), "fd_waveTypeReapers" )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_TitanSpawn( wave2, "Ion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave2, "Ion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 4 )
	
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "TickReaper", < 2516, 368, 255 >, 0, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "MortarSpectre", < 2147, 139, 176 >, 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_TitanSpawn( wave2, "Ronin", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_TitanSpawn( wave2, "Ronin", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave2, 2 )
	
	WaveSpawn_TitanSpawn( wave2, "Ion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave2, "Legion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave2, "Scorch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave2, "Legion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave2, "Ion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave2, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave2, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave2, "PodGrunt", infantrySpawns.getrandom(), 0.0, "" )
	
    WaveSpawnEvents.append( wave2 )
	
	/*
	 __      __                 ____
	 \ \    / /__ _ __ __ ___  |__ /
	  \ \/\/ // _` |\ V // -_)  |_ \
	   \_/\_/ \__,_| \_/ \___| |___/
	
	*/
	array<WaveSpawnEvent> wave3
	WaveSpawn_SmokeWall( wave3, < 3719, 1924, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < -258, 1569, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 3168, 866, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 3592, 464, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 3095, 385, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 764, 2425, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 1809, -237, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 2736, 1872, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 1683, 2418, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 748, 1091, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 2290, 2371, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 325, 1688, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 3588, 1291, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 711, 1474, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 1881, 892, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 3291, 1839, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 1210, -793, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 1815, 241, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 3496, -65, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 2242, -225, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 3015, 2413, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 1348, 1044, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 2084, 1859, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 2843, -72, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 645, -937, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 874, 1817, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 1828, -692, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 325, -1421, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 2558, 879, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 80, 701, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < 1486, 1899, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave3, < -282, -1319, 144 >, 2.5, 300 )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0, "fd_incCloakDroneClump" )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 6 )
	
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 6 )
	
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ), "fd_waveTypeTitanMortar" )
	WaveSpawn_InfantrySpawn( wave3, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave3, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave3, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 2 )
	
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave3, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave3, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave3, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 2 )
	
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ), "fd_waveComboArcMortar" )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave3, "TickReaper", < 2516, 368, 255 >, 0, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave3, "MortarSpectre", < 2147, 139, 176 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave3, 2 )
	
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave3, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave3, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave3, "ArcTitan", titanSpawns.getrandom(), 180, "" )
	
    WaveSpawnEvents.append( wave3 )
	
	/*
	 __      __                 _ _  
	 \ \    / /__ _ __ __ ___  | | | 
	  \ \/\/ // _` |\ V // -_) |_  _|
	   \_/\_/ \__,_| \_/ \___|   |_| 
	
	*/
	array<WaveSpawnEvent> wave4
	WaveSpawn_TitanSpawn( wave4, "Scorch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Scorch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Scorch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_Announce( wave4, "PreNukeTitan", 0.0 )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 2 )
	
	WaveSpawn_TitanSpawn( wave4, "Tone", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Tone", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Tone", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_TitanSpawn( wave4, "Ion", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Tone", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Monarch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave4, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave4, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ), "fd_waveTypeTitanNuke" )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave4, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "TickReaper", < 2516, 368, 255 >, 0, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave4, "MortarSpectre", < 2147, 139, 176 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave4, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave4, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave4, "Mortar", specialTitanSpawns.getrandom(), 180, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_Announce( wave4, "EliteTitans", 0.0 )
	WaveSpawn_TitanSpawn( wave4, "Northstar", specialTitanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Northstar", specialTitanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Northstar", specialTitanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave4, 4 )
	
	WaveSpawn_TitanSpawn( wave4, "Ronin", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Ronin", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Ronin", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave4, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave4, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave4, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave4, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave4, "Northstar", specialTitanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Northstar", specialTitanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave4, "Northstar", specialTitanSpawns.getrandom(), 0, "", 0.5, "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	
    WaveSpawnEvents.append( wave4 )
	
	/*
	 __      __                 ___ 
	 \ \    / /__ _ __ __ ___  | __|
	  \ \/\/ // _` |\ V // -_) |__ \
	   \_/\_/ \__,_| \_/ \___| |___/
	
	*/
	array<WaveSpawnEvent> wave5
	WaveSpawn_Announce( wave5, "Everything", 0.0 )
	WaveSpawn_TitanSpawn( wave5, "Ion", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave5, "Legion", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave5, "Scorch", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave5, "Legion", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave5, "Ion", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", infantrySpawns.getrandom(), 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ), "fd_waveComboArcNuke" )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_TitanSpawn( wave5, "Northstar", specialTitanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", specialTitanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Northstar", specialTitanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_ReaperSpawn( wave5, "TickReaper", < 2516, 368, 255 >, 0, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", < 2147, 139, 176 >, 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_ReaperSpawn( wave5, "Reaper", reaperSpawns.getrandom(), 180, "", RandomFloatRange( 0.4, 1.6 ) )
	WaveSpawn_TitanSpawn( wave5, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ), "fd_incTitansMortarClump" )
	WaveSpawn_TitanSpawn( wave5, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave5, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Ronin", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Ronin", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Ronin", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave5, "MortarSpectre", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.6 ) )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "PodGrunt", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.2, 0.8 ) )
	WaveSpawn_TitanSpawn( wave5, "Legion", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Legion", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Scorch", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Scorch", titanSpawns.getrandom(), 0, "", RandomFloatRange( 0.8, 2.4 ), "", 0.0, eFDSD.ALL, eFDTT.TITAN_ELITE )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 0 )
	
	WaveSpawn_NukeTitanMoveStance( wave5, true, 0.0 )
	WaveSpawn_Announce( wave5, "TitanfallBlock", 0.0 )
	WaveSpawn_TitanfallBlock( wave5, true, 5.0 )
	WaveSpawn_SmokeWall( wave5, < 2242, -225, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -243, -795, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 874, 1817, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -2242, -2140, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 2736, 1872, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -2468, -1608, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -2243, -362, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -962, -1887, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -3049, -1672, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -753, -1403, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 1809, -237, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 325, -1421, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 711, 1474, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 645, -937, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 764, 2425, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -2256, 914, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 1683, 2418, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 1881, 892, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -2191, 211, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 80, 701, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 3496, -65, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -3192, 314, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 2843, -72, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 1815, 241, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 1348, 1044, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -282, -1319, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1758, -2221, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 3095, 385, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 3291, 1839, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -3764, -1995, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -3495, -1618, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 748, 1091, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1078, 1092, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 2084, 1859, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1156, -1301, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 3015, 2413, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 2558, 879, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1933, -808, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -2699, -2124, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -833, 1594, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -4054, -1672, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -3221, -2194, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1669, 1037, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 325, 1688, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 1210, -793, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 3592, 464, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 3168, 866, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1237, -2231, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 2290, 2371, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -198, -66, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 3719, 1924, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1457, -1721, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -2746, -659, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -604, -362, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 3588, 1291, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1946, -1667, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -3237, -691, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -1366, -833, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -258, 1569, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -817, -833, 143 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 27, 462, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 1486, 1899, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < 1828, -692, 144 >, 0.2, 300 )
	WaveSpawn_SmokeWall( wave5, < -2617, 475, 144 >, 2.5, 300 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ), "fd_incTitansNukeClump" )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave5, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 8 )
	
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_TitanSpawn( wave5, "Mortar", specialTitanSpawns.getrandom(), 180, "", RandomFloatRange( 0.5, 2.0 ) )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "" )
	WaveSpawn_WaitEnemyAliveAmount( wave5, 6 )
	
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "ArcTitan", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "Stalker", infantrySpawns.getrandom(), 0.0, "", RandomFloatRange( 0.3, 0.9 ) )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_InfantrySpawn( wave5, "CloakDrone", titanSpawns.getrandom() + < 0, 0, 2500 >, 0.0, "", 1.0 )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "", RandomFloatRange( 0.3, 2.5 ) )
	WaveSpawn_TitanSpawn( wave5, "Nuke", titanSpawns.getrandom(), 180, "" )
	
    WaveSpawnEvents.append( wave5 )
}

void function RegisterCustomFDContent()
{
	array<entity> aiPositions = GetEntArrayByClass_Expensive( "info_target" )
	foreach ( entity position in aiPositions )
		if( position.HasKey( "editorclass" ) && position.kv.editorclass == "info_fd_ai_position" )
			position.Destroy()
		
	AddFDCustomTitanStart( < -3998, 374, 22 >, < 0, -45, 0 > )
	AddFDCustomTitanStart( < -4068, -1818, 31 >, < 0, 45, 0 > )
	
	AddStationaryAIPosition( < 1724, 1079, 3 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 1991, -210, -12 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 2917, 2182, 4 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 1506, 2299, 100 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 197, 460, 0 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 897, 1408, 33 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 3119, 186, 19 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	AddStationaryAIPosition( < 3688, 1347, 0 >, eStationaryAIPositionTypes.MORTAR_TITAN )
	
	AddStationaryAIPosition( < 2598, 543, 264 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 1274, 1444, 272 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 1548, 533, 272 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < -1564, -155, 272 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < -1529, -1201, 272 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	AddStationaryAIPosition( < 1205, 390, 272 >, eStationaryAIPositionTypes.MORTAR_SPECTRE )
	
	AddStationaryAIPosition( < 2053, -767, 45 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 3649, 1832, 10 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 3417, 902, 8 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < 889, 2536, 57 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < -1248, -800, -7 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < -2357, 938, 32 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	AddStationaryAIPosition( < -968, -2288, 24 >, eStationaryAIPositionTypes.SNIPER_TITAN )
	
	AddStationaryAIPosition( < 1205, 1063, 301 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 2088, 480, 327 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 527, 762, 272 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < -1589, -816, 279 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < -1960, -256, 271 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 2318, 1169, 128 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 3544, -50, 18 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 3371, 2251, 35 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	AddStationaryAIPosition( < 2215, -455, 23 >, eStationaryAIPositionTypes.LAUNCHER_REAPER )
	
	routes[ "longStraightL" ] <- []
	routes[ "longStraightL" ].append( < 3360, 1881, 11 > )
	routes[ "longStraightL" ].append( < 705, 1840, 4 > )
	routes[ "longStraightL" ].append( < -938, 1354, 2 > )
	routes[ "longStraightL" ].append( < -2423, 571, -16 > )
	routes[ "longStraightL" ].append( < -2252, -681, 18 > )
	routes[ "longStraightL" ].append( < -3650, -657, 25 > )
	
	routes[ "longStraightC" ] <- []
	routes[ "longStraightC" ].append( < 3300, 903, 26 > )
	routes[ "longStraightC" ].append( < 392, 1100, 4 > )
	routes[ "longStraightC" ].append( < -581, -655, 1 > )
	routes[ "longStraightC" ].append( < -581, -655, 1 > )
	routes[ "longStraightC" ].append( < -2252, -681, 18 > )
	routes[ "longStraightC" ].append( < -3650, -657, 25 > )
	
	routes[ "longStraightR" ] <- []
	routes[ "longStraightR" ].append( < 3292, -7, 32 > )
	routes[ "longStraightR" ].append( < 1153, -797, 3 > )
	routes[ "longStraightR" ].append( < -1082, -1625, 1 > )
	routes[ "longStraightR" ].append( < -3595, -1632, 32 > )
	routes[ "longStraightR" ].append( < -3959, -1138, 1 > )
	
	routes[ "longFullCorner" ] <- []
	routes[ "longFullCorner" ].append( < 1685, 2472, 42 > )
	routes[ "longFullCorner" ].append( < 465, 1698, -9 > )
	routes[ "longFullCorner" ].append( < -967, 1131, 40 > )
	routes[ "longFullCorner" ].append( < -2626, 482, 1 > )
	routes[ "longFullCorner" ].append( < -3826, -267, 13 > )
	
	routes[ "infantryUpperClose" ] <- []
	routes[ "infantryUpperClose" ].append( < -1340, -289, 271 > )
	routes[ "infantryUpperClose" ].append( < -1840, -810, -27 > )
	routes[ "infantryUpperClose" ].append( < -3604, -526, 31 > )
	
	routes[ "infantryUpperFar" ] <- []
	routes[ "infantryUpperFar" ].append( < 1079, 513, 271 > )
	routes[ "infantryUpperFar" ].append( < 729, 1296, -1 > )
	routes[ "infantryUpperFar" ].append( < -921, 1394, 0 > )
	routes[ "infantryUpperFar" ].append( < -2679, 532, 0 > )
	routes[ "infantryUpperFar" ].append( < -3961, -174, 15 > )
	
	routes[ "lowerClose" ] <- []
	routes[ "lowerClose" ].append( < -528, -1029, 21 > )
	routes[ "lowerClose" ].append( < -1478, -1617, 12 > )
	routes[ "lowerClose" ].append( < -3715, -1575, 14 > )
	routes[ "lowerClose" ].append( < -4046, -1146, 2 > )
	
	routes[ "lowerFar" ] <- []
	routes[ "lowerFar" ].append( < 114, 1273, 20 > )
	routes[ "lowerFar" ].append( < -1018, 1142, 31 > )
	routes[ "lowerFar" ].append( < -2387, 559, -15 > )
	routes[ "lowerFar" ].append( < -3675, -369, 5 > )
}